@extends('layouts.main')

@section('styles')
@endsection

@section('content')

<!-- Start main-content -->
<div class="main-content">
  <!-- Section: inner-header -->
  <section class="inner-header divider parallax layer-overlay overlay-dark-5" data-bg-img="{{ asset('assets/images/bg/bg6.jpg')}}" style="background-image: url(&quot;images/bg/bg6.jpg&quot;); background-position: 50% 58px;">
    <div class="container pt-30 pb-40">
      <!-- Section Content -->
      <div class="section-content">
        <div class="row">
          <div class="col-md-12">
            <h2 class="title text-white text-center">Course: {{$course->name}}</h2>
          </div>
        </div>
      </div>
    </div>
  </section>
  <section>
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <div class="row mb-15">
            <div class="col-sm-6 col-md-4">
              <div class="thumb"> <img alt="featured project" src="images/project/lg1.jpg" class="img-fullwidth"></div>
            </div>
            <div class="col-sm-6 col-md-8">
              <h2 class="line-bottom line-bottom2 mt-0 mt-sm-20">{{$course->name}}</h2>
              <p>{{$course->description}}</p>
              <a class="btn btn-danger  btn-md text-uppercase mt-10" href="{{ route('registration', Crypt::encrypt($course->id))}}">Register now</a>
            </div>
          </div>
          <div class="row mb-15">
            <ul class="list list-divider list-border2">
              <li><i class="fa fa-check-square-o mr-10 text-black-light"></i> <strong>Department: </strong> {{$course->department}}</li>
              <li><i class="fa fa-check-square-o mr-10 text-black-light"></i> <strong>Course Developer: </strong> {{$course->course_developer}}</li>
              <li><i class="fa fa-check-square-o mr-10 text-black-light"></i> <strong>Development Date:</strong> {{$course->delopment_date}}</li>
              <li><i class="fa fa-check-square-o mr-10 text-black-light"></i> <strong>Revision Date:</strong> {{$course->revision_date}}</li>
              <li><i class="fa fa-check-square-o mr-10 text-black-light"></i> <strong>Course Title:</strong> {{$course->name}}</li>
              <li><i class="fa fa-check-square-o mr-10 text-black-light"></i> <strong>Course Reviser:</strong> {{$course->course_reviser}}</li>
              <li><i class="fa fa-check-square-o mr-10 text-black-light"></i> <strong>Grade: </strong> {{$course->grade->name}}</li>
              <li><i class="fa fa-check-square-o mr-10 text-black-light"></i> <strong>Course Type:</strong> {{$course->course_type}}</li>
              <li><i class="fa fa-check-square-o mr-10 text-black-light"></i> <strong>Ministry Course Code:</strong> {{$course->ministry_course_code}}</li>
              <li><i class="fa fa-check-square-o mr-10 text-black-light"></i> <strong>Credit Value:</strong> {{$course->credit_value}}</li>
              <li><i class="fa fa-check-square-o mr-10 text-black-light"></i> <strong>Prerequisite: </strong> {{$course->prerequisite}}</li>
              <li><i class="fa fa-check-square-o mr-10 text-black-light"></i> <strong>Ministry Curriculum Policy Document:</strong> {{$course->ministry_curriculum_policy_doc}}</li>
            </ul>
          </div>
          <div class="row mb-15">
            <h3 class="text-uppercase mt-15">Overall <span class="text-theme-color-2">Curriculum Expectations </span></h3>
            <div class="row">
              <div class="col-md-3 pr-0">
                <div class="vertical-tab">
                  <ul class="nav nav-tabs">
                    @foreach($course->expectations as $ce)
                    <li class=" @if($loop->iteration == 1) active @endif"><a href="#{{$ce->title}}_{{$ce->id}}" data-toggle="tab">{{$ce->title}}</a></li>
                    @endforeach

                  </ul>
                </div>
              </div>
              <div class="col-md-9 pl-0">
                <div class="tab-content">
                  @foreach($course->expectations as $ee)
                  <div class="tab-pane fade  @if($loop->iteration == 1) in active @endif" id="{{$ee->title}}_{{$ee->id}}">
                    <div class="row">
                      <div class="col-md-12">
                        <h4 class="text-danger">{{$ee->title}}</h4>
                        <ul>
                          {{$ee->description}}
                          </ul>
                      </div>
                    </div>
                  </div>
                  @endforeach

                </div>
              </div>
            </div>
          </div>
          <div class="row mb-15">
            <h3 class="text-uppercase mt-15">Unit <span class="text-theme-color-2">Outline </span></h3>
            <div class="col-md-12">
              <div data-example-id="contextual-table" class="bs-example row">
                <table class="table">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Unit</th>
                      <th>Approx. Time</th>

                    </tr>
                  </thead>
                  <tbody>
                    @php $msum = 0; @endphp
                    @foreach($course->outlines as $key=>$oo)
                    @if($oo->title != null && $oo->title != "")
                    <tr class="@if($key % 2 == 0) active  @endif">
                      <th scope="row">{{$loop->iteration}}</th>
                      <td> {{$oo->title}}</td>
                      <td>{{$oo->timeline}} Hours</td>
                    @php  $msum = $msum + $oo->timeline; @endphp
                    </tr>
                    @endif
                    @endforeach

                    <tr class="danger">
                      <th scope="row"></th>
                      <td><strong>Total</strong></td>
                      <td><strong>{{$msum}} Hours</strong></td>

                    </tr>

                  </tbody>
                </table>
              </div>
            </div>
          </div>

          <div class="row mb-15">
            <h3 class="text-uppercase mt-15">Unit <span class="text-theme-color-2">Description </span></h3>
            <div class="row">
              <div class="col-md-3 pr-0">
                <div class="vertical-tab">
                  <ul class="nav nav-tabs">
                    @foreach($course->outlines_considerations as $ocs)
                    <li class="@if($loop->iteration == 1) active @endif"><a href="#{{$ocs->title}}_{{$ocs->id}}" data-toggle="tab"><strong>{{$ocs->title}}</strong><br/></a></li>
                    @endforeach

                  </ul>
                </div>
              </div>
              <div class="col-md-9 pl-0">
                <div class="tab-content">
                    @foreach($course->outlines_considerations as $occ)
                  <div class="tab-pane fade @if($loop->iteration ==1) in active @endif" id="{{$occ->title}}_{{$occ->id}}">
                    <div class="row">
                      <div class="col-md-12">
                        <h4 class="text-danger">{{$occ->title}}</h4>
                        <p>{{$occ->description}}</p>
                      </div>
                    </div>
                  </div>
                  @endforeach


                </div>
              </div>
            </div>
          </div>

          <div class="row mb-15">
            <h3 class="text-uppercase mt-15">Program <span class="text-theme-color-2">Considerations </span></h3>
            <div class="col-md-12 pt-20">

            <ul id="myTab2" class="nav nav-pills boot-tabs row">
              <li class="active"><a href="#assesment" data-toggle="tab" aria-expanded="true">Assessment and Evaluation</a></li>
              <li class=""><a href="#learning" data-toggle="tab" aria-expanded="false">Teaching & Learning Strategies</a></li>

            </ul>
            <div id="myTabContent2" class="tab-content tab-content2 row">
              <div class="tab-pane fade active in" id="assesment">
              <h3>Assessment and Evaluation</h3>
              {{$course->evaluation}}
              </div>




              <div class="tab-pane fade" id="learning">
              <h3>Teaching & Learning Strategies</h3>
                {{$course->strategy}}
              </div>


            </div>
          </div>
          </div>

          <div class="col-md-6 col-md-offset-3 mt-10 mb-20"><a href="{{ route('registration', Crypt::encrypt($course->id))}}" class="btn btn-primary btn-xlg btn-block">Register Now for a Course</a></div>
        </div>
      </div>
    </div>
  </section>
</div>
<!-- end main-content -->


@endsection

@section('scripts')

@endsection
